/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardWaiter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.SystemAccess;
import opencard.core.util.Tracer;

public final class SmartCard {
    private static final String VERSION = "OCF1.2;IBM Reference Implementation, Build ???, XX-XXXXXX-1999";
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$SmartCard != null ? class$opencard$core$service$SmartCard : (class$opencard$core$service$SmartCard = SmartCard.class$("opencard.core.service.SmartCard")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$SmartCard != null ? class$opencard$core$service$SmartCard : (class$opencard$core$service$SmartCard = SmartCard.class$("opencard.core.service.SmartCard")));
    private CardServiceScheduler scheduler;
    private CardID cid;
    private CardChannel mutexCardChannel;
    private static boolean OCFisStarted;
    private Vector allocatedCS = new Vector();
    private static Vector smartCardCache;
    private static int refCount_;
    static /* synthetic */ Class class$opencard$core$service$SmartCard;

    public static String getVersion() {
        return VERSION;
    }

    public SmartCard(CardServiceScheduler cardServiceScheduler, CardID cardID) {
        ctracer.debug("<init>", "scheduler " + cardServiceScheduler + ", cid " + cardID);
        this.scheduler = cardServiceScheduler;
        this.cid = cardID;
    }

    private void assertSmartCardOpen() {
        try {
            if (!this.scheduler.isAlive()) {
                throw new OpenCardRuntimeException("SmartCard closed");
            }
        }
        catch (CardTerminalException cardTerminalException) {
            throw new OpenCardRuntimeException("SmartCard closed");
        }
    }

    public void beginMutex() throws InterruptedException, CardTerminalException {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            ctracer.debug("beginMutex", "entry " + this);
            this.assertSmartCardOpen();
            this.mutexCardChannel = this.scheduler.allocateCardChannel(this, true);
            if (this.mutexCardChannel == null) {
                throw new InterruptedException("beginMutex");
            }
            Enumeration enumeration = this.allocatedCS.elements();
            while (enumeration.hasMoreElements()) {
                CardService cardService = (CardService)enumeration.nextElement();
                cardService.setCardChannel(this.mutexCardChannel);
            }
            ctracer.debug("beginMutex", "exit " + this);
            return;
        }
    }

    public synchronized void close() throws CardTerminalException {
        if (this.scheduler != null) {
            this.itracer.debug("close", "SmartCard closing");
            if (this.mutexCardChannel != null) {
                this.endMutex();
            }
            this.scheduler.releaseSmartCard(this);
        }
        smartCardCache.removeElement(this);
    }

    private static void configureServiceRegistry() throws CardServiceException {
        CardServiceRegistry cardServiceRegistry = CardServiceRegistry.getRegistry();
        StringTokenizer stringTokenizer = SmartCard.getRegistryEntry("OpenCard.services");
        if (stringTokenizer != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                try {
                    Class<?> clazz = Class.forName(string);
                    cardServiceRegistry.add((CardServiceFactory)clazz.newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ctracer.error("<configureServiceRegistry>", classNotFoundException.getMessage());
                    stringBuffer.append("\nClass \"").append(string).append("\" not found");
                }
                catch (InstantiationException instantiationException) {
                    ctracer.error("<configureServiceRegistry>", instantiationException.getMessage());
                    stringBuffer.append("\nClass \"").append(string).append("\" not instantiatable");
                }
                catch (IllegalAccessException illegalAccessException) {
                    ctracer.error("<configureServiceRegistry>", illegalAccessException.getMessage());
                    stringBuffer.append("\nClass \"").append(string).append("\" constructor not accessible");
                }
            }
            if (stringBuffer.length() > 0) {
                throw new CardServiceException(stringBuffer.toString());
            }
        } else {
            ctracer.debug("configureServiceRegistry", "no services entry in properties");
        }
    }

    private static void configureTerminalRegistry() throws ClassNotFoundException, CardTerminalException {
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        StringTokenizer stringTokenizer = SmartCard.getRegistryEntry("OpenCard.terminals");
        Hashtable hashtable = new Hashtable();
        if (stringTokenizer != null) {
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                SmartCard.handleTerminalFactoryEntries(string, hashtable, cardTerminalRegistry);
            }
            return;
        }
        ctracer.debug("configureTerminalRegistry", "no terminals in properties");
    }

    public synchronized void endMutex() {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            ctracer.debug("endMutex", "entry " + this);
            this.assertSmartCardOpen();
            this.scheduler.releaseCardChannel(this.mutexCardChannel);
            this.mutexCardChannel = null;
            Enumeration enumeration = this.allocatedCS.elements();
            while (enumeration.hasMoreElements()) {
                CardService cardService = (CardService)enumeration.nextElement();
                cardService.setCardChannel(null);
            }
            ctracer.debug("endMutex", "exit " + this);
            return;
        }
    }

    protected void finalize() {
        try {
            this.close();
            return;
        }
        catch (CardTerminalException cardTerminalException) {
            this.itracer.error("finalize", cardTerminalException.toString());
            return;
        }
    }

    public CardID getCardID() {
        return this.cid;
    }

    public CardService getCardService(Class clazz, boolean bl) throws ClassNotFoundException, CardServiceException {
        CardService cardService = null;
        this.itracer.debug("getCardService", "(" + clazz + ")");
        this.assertSmartCardOpen();
        cardService = CardServiceRegistry.getRegistry().getCardServiceInstance(clazz, this.cid, this.scheduler, this, bl);
        if (this.mutexCardChannel != null && this.mutexCardChannel.isOpen()) {
            cardService.setCardChannel(this.mutexCardChannel);
        }
        this.allocatedCS.addElement(cardService);
        return cardService;
    }

    private static StringTokenizer getRegistryEntry(String string) {
        String string2 = SystemAccess.getSystemAccess().getProperty(string);
        ctracer.debug("getRegistryEntry", "tag " + string + " = " + string2);
        if (string2 != null) {
            return new StringTokenizer(string2);
        }
        return null;
    }

    public static SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        return SmartCard.getSmartCard(cardTerminalEvent, null, null);
    }

    public static SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent, CardRequest cardRequest) throws CardTerminalException {
        return SmartCard.getSmartCard(cardTerminalEvent, cardRequest, null);
    }

    public static SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent, CardRequest cardRequest, Object object) throws CardTerminalException {
        SmartCard smartCard = CardServiceRegistry.getRegistry().getSmartCard(cardTerminalEvent, cardRequest, object);
        if (smartCard != null) {
            smartCardCache.addElement(smartCard);
        }
        return smartCard;
    }

    private static void handleTerminalFactoryEntries(String string, Hashtable hashtable, CardTerminalRegistry cardTerminalRegistry) throws ClassNotFoundException, CardTerminalException {
        CardTerminalFactory cardTerminalFactory = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n - 1];
            int n2 = 0;
            String string2 = null;
            while (stringTokenizer.hasMoreElements()) {
                if (n2 == 0) {
                    string2 = (String)stringTokenizer.nextElement();
                } else {
                    stringArray[n2 - 1] = (String)stringTokenizer.nextElement();
                }
                ++n2;
            }
            cardTerminalFactory = (CardTerminalFactory)hashtable.get(string2);
            if (cardTerminalFactory == null) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    cardTerminalFactory = (CardTerminalFactory)clazz.newInstance();
                    hashtable.put(string2, cardTerminalFactory);
                }
                catch (InstantiationException instantiationException) {
                    throw new CardTerminalException(instantiationException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CardTerminalException(illegalAccessException.toString());
                }
            }
            cardTerminalFactory.createCardTerminals(cardTerminalRegistry, stringArray);
        }
    }

    public static boolean isStarted() {
        return OCFisStarted;
    }

    public static void shutdown() throws CardTerminalException {
        ctracer.debug("<shutdown>", "shutdown OpenCard");
        if (--refCount_ == 0) {
            while (!smartCardCache.isEmpty()) {
                ((SmartCard)smartCardCache.firstElement()).close();
            }
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
            while (enumeration.hasMoreElements()) {
                cardTerminalRegistry.remove((CardTerminal)enumeration.nextElement());
            }
            CardServiceRegistry cardServiceRegistry = CardServiceRegistry.getRegistry();
            Enumeration enumeration2 = cardServiceRegistry.getCardServiceFactories();
            while (enumeration2.hasMoreElements()) {
                cardServiceRegistry.remove((CardServiceFactory)enumeration2.nextElement());
            }
            OCFisStarted = false;
        }
    }

    public static synchronized void start() throws OpenCardPropertyLoadingException, ClassNotFoundException, CardServiceException, CardTerminalException {
        if (!OCFisStarted) {
            ctracer.debug("<start>", "startup opencard");
            String string = SystemAccess.getSystemAccess().getProperty("OpenCard.loaderClassName", "opencard.opt.util.OpenCardPropertyFileLoader");
            if (string != null && string.length() > 0) {
                ctracer.debug("<start>", "use loader class: " + string);
                try {
                    Class<?> clazz = Class.forName(string);
                    OpenCardConfigurationProvider openCardConfigurationProvider = (OpenCardConfigurationProvider)clazz.newInstance();
                    openCardConfigurationProvider.loadProperties();
                    ctracer.debug("<start>", "loader loaded properties: ");
                }
                catch (InstantiationException instantiationException) {
                    throw new CardServiceOperationFailedException(instantiationException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CardServiceOperationFailedException(illegalAccessException.toString());
                }
            } else {
                ctracer.debug("<start>", "did not use a loader class!");
            }
            Tracer.init();
            EventGenerator.getGenerator();
            SmartCard.configureTerminalRegistry();
            SmartCard.configureServiceRegistry();
            OCFisStarted = true;
        } else {
            ctracer.debug("<start>", "already configured");
        }
        ++refCount_;
        ctracer.debug("<start>", "finished");
    }

    public static SmartCard waitForCard(CardRequest cardRequest) throws CardTerminalException {
        return SmartCard.waitForCard(cardRequest, null);
    }

    public static SmartCard waitForCard(CardRequest cardRequest, Object object) throws CardTerminalException {
        ctracer.debug("waitForCard", "passing request " + cardRequest + " to CardServiceRegistry");
        CardWaiter cardWaiter = new CardWaiter(cardRequest, object);
        SmartCard smartCard = cardWaiter.waitForCard();
        if (smartCard != null) {
            smartCardCache.addElement(smartCard);
        }
        return smartCard;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        smartCardCache = new Vector();
    }
}

