/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

class CardWaiter
implements CTListener {
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardWaiter != null ? class$opencard$core$service$CardWaiter : (class$opencard$core$service$CardWaiter = CardWaiter.class$("opencard.core.service.CardWaiter")));
    private SmartCard smartCard_;
    private CardRequest cardRequest_;
    private Object lockHandle_;
    private CardTerminalException cardTerminalException_;
    static /* synthetic */ Class class$opencard$core$service$CardWaiter;

    public CardWaiter(CardRequest cardRequest, Object object) throws CardTerminalException {
        ctracer.debug("<init>", "Request: " + cardRequest);
        this.cardRequest_ = cardRequest;
        this.lockHandle_ = object;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        if (this.smartCard_ == null) {
            ctracer.debug("cardInserted", "CTEvent: " + cardTerminalEvent);
            try {
                this.smartCard_ = SmartCard.getSmartCard(cardTerminalEvent, this.cardRequest_, this.lockHandle_);
                if (this.smartCard_ != null) {
                    CardWaiter cardWaiter = this;
                    synchronized (cardWaiter) {
                        this.notify();
                        return;
                    }
                }
            }
            catch (CardTerminalException cardTerminalException) {
                this.cardTerminalException_ = cardTerminalException;
                CardWaiter cardWaiter = this;
                synchronized (cardWaiter) {
                    this.notify();
                    return;
                }
            }
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
    }

    public synchronized SmartCard waitForCard() throws CardTerminalException {
        long l = this.cardRequest_.getTimeout() * 1000;
        if (this.cardRequest_.getWaitBehavior() == 1) {
            EventGenerator.getGenerator().createEventsForPresentCards(this);
        }
        try {
            EventGenerator.getGenerator().addCTListener(this);
            while (!(this.cardRequest_.isTimeoutSet() && l <= 0L || this.smartCard_ != null)) {
                long l2 = System.currentTimeMillis();
                try {
                    if (this.cardRequest_.isTimeoutSet()) {
                        this.wait(l);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                l -= System.currentTimeMillis() - l2;
                if (this.cardTerminalException_ == null) continue;
                throw this.cardTerminalException_;
            }
            ctracer.debug("waitForCard", "SmartCard obtained: " + this.smartCard_);
            SmartCard smartCard = this.smartCard_;
            Object var5_4 = null;
            EventGenerator.getGenerator().removeCTListener(this);
            return smartCard;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            EventGenerator.getGenerator().removeCTListener(this);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

