/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Hashtable;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardServiceScheduler
implements CTListener {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardServiceScheduler != null ? class$opencard$core$service$CardServiceScheduler : (class$opencard$core$service$CardServiceScheduler = CardServiceScheduler.class$("opencard.core.service.CardServiceScheduler")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardServiceScheduler != null ? class$opencard$core$service$CardServiceScheduler : (class$opencard$core$service$CardServiceScheduler = CardServiceScheduler.class$("opencard.core.service.CardServiceScheduler")));
    private SlotChannel slot_channel;
    private int card_slot;
    private CardTerminal card_terminal;
    private CardChannel current_channel;
    private int smartcard_refs;
    private boolean is_alive = false;
    private CardChannel free_channel;
    private boolean is_customized = false;
    private Hashtable card_types = new Hashtable();
    private int threads;
    static /* synthetic */ Class class$opencard$core$service$CardServiceScheduler;

    public CardServiceScheduler(SlotChannel slotChannel) {
        ctracer.debug("<init>", "slotChannel " + slotChannel);
        this.slot_channel = slotChannel;
        this.card_terminal = slotChannel.getCardTerminal();
        this.card_slot = slotChannel.getSlotNumber();
        this.is_alive = true;
        this.free_channel = new CardChannel(slotChannel);
        EventGenerator.getGenerator().addCTListener(this);
    }

    public void setCustomChannel(CardChannel cardChannel) throws InvalidCardChannelException {
        if (this.is_customized) {
            throw new InvalidCardChannelException("scheduler already customized");
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = cardChannel;
        this.is_customized = true;
    }

    public void useDefaultChannel() throws InvalidCardChannelException {
        if (!this.is_customized) {
            return;
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("custom channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = new CardChannel(this.slot_channel);
        this.is_customized = false;
    }

    public final boolean isCustomized() {
        return this.is_customized;
    }

    public final SlotChannel getSlotChannel() {
        return this.slot_channel;
    }

    public synchronized CardChannel allocateCardChannel(Object object, boolean bl) throws CardTerminalException {
        this.assertLiveness();
        if (this.threads > 0 && !bl) {
            return null;
        }
        this.itracer.debug("allocateCardChannel", "applicant " + object);
        ++this.threads;
        if (this.threads > 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.itracer.alert("allocateCardChannel", interruptedException);
                --this.threads;
                return null;
            }
            if (!this.isAlive()) {
                this.itracer.warning("allocateCardChannel", "scheduler died while waiting for CardChannel");
                return null;
            }
        }
        this.free_channel.open();
        this.current_channel = this.free_channel;
        this.free_channel = null;
        return this.current_channel;
    }

    public synchronized void releaseCardChannel(CardChannel cardChannel) throws InvalidCardChannelException {
        this.itracer.debug("releaseCardChannel", "releasing " + cardChannel);
        if (this.current_channel != cardChannel && this.is_alive) {
            throw new InvalidCardChannelException("channel not current channel");
        }
        cardChannel.close();
        this.current_channel = null;
        this.free_channel = cardChannel;
        --this.threads;
        this.notify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final CardID reset(CardChannel cardChannel, boolean bl) throws CardTerminalException {
        CardID cardID;
        boolean bl2;
        block5: {
            CardID cardID2;
            block4: {
                bl2 = false;
                try {
                    if (cardChannel == null) {
                        cardChannel = this.allocateCardChannel(this, bl);
                        bl2 = true;
                    }
                    if (cardChannel == null) {
                        cardID2 = null;
                        Object var6_6 = null;
                        if (!bl2) return cardID2;
                        break block4;
                    }
                    CardID cardID3 = this.slot_channel.reset();
                    cardChannel.setState(null);
                    cardID = cardID3;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!bl2) throw throwable;
                    this.releaseCardChannel(cardChannel);
                    throw throwable;
                }
            }
            this.releaseCardChannel(cardChannel);
            return cardID2;
        }
        Object var6_7 = null;
        if (!bl2) return cardID;
        this.releaseCardChannel(cardChannel);
        return cardID;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        if (cardTerminalEvent.getSlotID() == this.card_slot && cardTerminalEvent.getCardTerminal() == this.card_terminal) {
            this.itracer.debug("cardRemoved", "event " + cardTerminalEvent);
            this.closeDown();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(", ").append(this.is_alive ? "is" : "not").append(" alive");
        if (this.threads > 0) {
            stringBuffer.append("\n++  channel is allocated");
        }
        if (this.threads > 1) {
            stringBuffer.append("\n++ " + (this.threads - 1) + " threads waiting for channel");
        }
        return stringBuffer.toString();
    }

    protected final boolean isAlive() throws CardTerminalException {
        if (this.is_alive && (this.slot_channel == null || !this.slot_channel.isOpen())) {
            this.closeDown();
        }
        return this.is_alive;
    }

    protected synchronized SmartCard createSmartCard(CardID cardID) throws CardTerminalException {
        this.itracer.debug("createSmartCard", "creating SmartCard");
        SmartCard smartCard = null;
        try {
            this.assertLiveness();
            smartCard = new SmartCard(this, cardID);
            ++this.smartcard_refs;
        }
        catch (OpenCardRuntimeException openCardRuntimeException) {
            this.itracer.debug("createSmartCard", "could not create SmartCard");
        }
        return smartCard;
    }

    protected synchronized void releaseSmartCard(SmartCard smartCard) throws CardTerminalException {
        this.itracer.debug("releaseSmartCard", "releasing " + smartCard);
        --this.smartcard_refs;
        if (this.smartcard_refs < 1) {
            this.itracer.info("releaseSmartCard", "no more SmartCards, closing down");
            this.closeDown();
        }
    }

    void setCardTypeFor(CardServiceFactory cardServiceFactory, CardType cardType) {
        this.card_types.put(cardServiceFactory, cardType);
    }

    CardType getCardTypeFor(CardServiceFactory cardServiceFactory) {
        return (CardType)this.card_types.get(cardServiceFactory);
    }

    private void assertLiveness() throws CardTerminalException {
        if (!this.isAlive()) {
            throw new InvalidCardChannelException("CardServiceScheduler dead");
        }
    }

    synchronized void closeDown() throws CardTerminalException {
        this.itracer.debug("closeDown", "closing down scheduler");
        if (!this.is_alive) {
            return;
        }
        CardServiceRegistry.getRegistry().releaseScheduler(this);
        this.is_alive = false;
        if (this.current_channel != null) {
            this.itracer.warning("closeDown", "closing " + this.current_channel);
            this.releaseCardChannel(this.current_channel);
        }
        this.free_channel.closeFinal();
        EventGenerator.getGenerator().removeCTListener(this);
        if (this.slot_channel.isOpen()) {
            this.slot_channel.close();
            this.slot_channel = null;
        }
        this.notifyAll();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

